/******************************************************************************
 CFind.c

				CFind Dialog Director Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 9:22 PM Thu, Aug 5, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the dialog class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CFind.h"
#include "FindItems.h"
#include "AppCommands.h"			// Remove comments if DoCommand overridden
#include "CAdaApp.h"

#include <CIntegerText.h>
#include <CControl.h>
#include <CPopup.h>
#include <CPopupPane.h>
#include <CArrayPane.h>
#include <CIconButton.h>
#include <CPictureButton.h>
#include <CSwissArmyButton.h>
#include <ViewUtilities.h>
#include <CButtonProc.h>

#include <CApplication.h>
#include <Constants.h>
#include <Commands.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <CDirectorOwner.h>
#include <CFile.h>
#include <TBUtilities.h>
#include <CWindow.h>

extern	CApplication *gApplication;		/* The application					*/
extern CDecorator	*gDecorator;		/* Decorator for arranging windows	*/
extern CDesktop		*gDesktop;			/* The visible Desktop				*/


/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICFind

	Initialize the dialog

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void CFind::ICFind(CDirectorOwner *aSupervisor)

{
		// Initialize data members that must be set up before
		// BeginData is called here

	x_CFind::Ix_CFind(aSupervisor);

		// Initialize any other data members here

}


/******************************************************************************
 BeginData

	Set up initial pane values
******************************************************************************/

void CFind::BeginData(CFindData *initial)

{
Boolean start, type;
CButtonProc *b;
CDialog *itsDialog = (CDialog*) itsWindow;

	 	//	Superclass calls BeginData once after the window is created
	 	//	to gather the initial values for the dialog panes. Note that
	 	//	BeginData is called *before* Ix_CFind returns. If you
	 	//	do not override this function, all values are initially
	 	//	zero or null.

	((CAdaApp *)gApplication)->GetSearchOptions(&initial->fFind_Edit4,
		 &initial->fFind_Edit5, &start, &type);

	// Start and type are ignored for now.  They are there to add
	// search from beginning and search using grep

	//initial->fFind_Rdio11 = (start == true);
	//initial->fFind_Rdio12 = (start != true);
	//initial->fFind_Rdio13 = (type == true);
	//initial->fFind_Rdio14 = (type != true);


	// Set state of Find button based on string in Find box
	//
	// Setting the default command here makes no difference
	// because the default value is passed in to the DoModalDialog
	// routine and reset there.
	b = (CButtonProc *)GetItemPointer((CView *)itsDialog, kFind_Butn7);
	if ((b != NULL) && (initial->fFind_Edit4[0] == 0)) {
		b->Deactivate();
	}
	else {
		b->Activate();
	}
}


/******************************************************************************
 UpdateData
 
 	React to changes by the user (or the program)
******************************************************************************/

void CFind::UpdateData(CFindUpdate *update, long itemNo)

{
CDialog *itsDialog = (CDialog*) itsWindow;

		//	UpdateData is called every time the user or the program
		//	changes the value of a dialog pane. (Changes you make to
		//	panes during a call to UpdateData do not result in
		//	recursive calls to UpdateData.)

		//	Override to dynamically update other program objects.
		//	Note that *only* the value corresponding to itemNo is present in
		//	the update record. If you need the values of other panes,
		//	you must ask the panes for them.

	if (itemNo == kFind_Edit4ID) {
		CButtonProc *b;
		
		b = (CButtonProc *)GetItemPointer((CView *)itsDialog, kFind_Butn7);
		if ((b != NULL) && (update->stringvalue[0] == 0)) {
			b->Deactivate();
			itsDialog->SetDefaultCmd(cmdDontFind);
		}
		else {
			b->Activate();
			itsDialog->SetDefaultCmd(cmdOK);
		}
	}
}


/******************************************************************************
 EndData
 
 	Receive final values from the dialog
******************************************************************************/

void CFind::EndData(CFindData *final)

{
Boolean start, type;
		//	The values of all panes are returned by this function,
		//	which is called just before Close for a modeless dialog,
		//	or just before returning from DoModalDialog.
		
		//	If DoModalDialog returns cmdCancel, EndData is called
		//	with the values initially supplied to BeginData, allowing
		//	you to back out any intermediate changes made in response
		//	to UpdateData. If you do not use UpdateData, you can
		//	test the value of dismissCmd to see whether to respond
		//	to EndData.


	 	//	Superclass calls BeginData once after the window is created
	 	//	to gather the initial values for the dialog panes. Note that
	 	//	BeginData is called *before* Ix_CFind returns. If you
	 	//	do not override this function, all values are initially
	 	//	zero or null.


	//start = (final->fFind_Rdio11 == 1);
	//type  = (final->fFind_Rdio13 == 1);

	((CAdaApp *)gApplication)->SetSearchOptions(final->fFind_Edit4,
		final->fFind_Edit5, start, type);
}


/******************************************************************************
 ProviderChanged	{OVERRIDE}
 	
 	A pane changed value
******************************************************************************/

void CFind::ProviderChanged(CCollaborator *aProvider, long reason, void* info)

{
		//	Override this function if you need to respond more directly
		//	to changes in pane values. See the superclass's ProviderChanged
		//	function for an example of how to check for changes.

		//	Note that there is a lot of traffic through this function
		//	in addition to change notices. Do not forget to call the
		//	superclass for all changes you do not handle completely.

	x_CFind::ProviderChanged(aProvider, reason, info);
}


/******************************************************************************
 DoCommand {OVERRIDE}

		Dispatch commands
 ******************************************************************************/

void CFind::DoCommand(long theCommand)

{
	switch (theCommand)
	{
			// Insert your command handler cases here, e.g.,
			//
			//	case cmdMine:
			//		DoMyCmd();
			//		break;

		case cmdDontFind:
			dismissCmd = theCommand;
			x_CFind::DoCommand(theCommand);
			break;

		default:
			x_CFind::DoCommand(theCommand);
	}
}
